
.CODE

	PUBLIC	WINHULLOPROC
WINHULLOPROC PROC WINDOWS PASCAL FAR hWnd:WORD,msgtype:WORD,wParam:WORD, \
							    lParam:DWORD
	LOCAL	dummy:WORD:5	;4 or less here can cause a crash.
	LOCAL	hDC:WORD
	LOCAL	s3:PAINTSTRUCT

	mov	ax,msgtype		;get message-type.
	cmp	ax,WM_CREATE		;message received after CreateWindow()
	je	xcreate			;function is called.
	cmp	ax,WM_DESTROY		;message received if a window is closed.
	je	xquitmessage
	cmp	ax,WM_PAINT		;message received if Windows has (already)
						;redrawn any part of the window (due to
						;a size-change for example).
	je	xpaint
	cmp	ax,WM_COMMAND		;any selection of the menu will produce
	jne	notwmcommand
	jmp	xmenu			;this message.
notwmcommand:
	cmp	ax,WM_LBUTTONDOWN	;one of many mouse messages.
	jne	notwmlbutton
	jmp	xbreak
notwmlbutton:
	cmp	ax,WM_CHAR		;message that a key pressed.
	je	xchar

;Default handling of messages....
  call	DEFWINDOWPROC PASCAL,hWnd,msgtype,wParam, WORD PTR lParam+2, \
							  WORD PTR lParam
	jmp	xreturn			;Back to Windows, which will in turn
					;return to after DispatchMessage().
;.................................
xcreate:
  call	GETSTOCKOBJECT PASCAL,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
	jmp	xbreak

xquitmessage:
  call	POSTQUITMESSAGE PASCAL,0
	jmp	xbreak

xchar:
	jmp 	xbreak

xpaint:
	lea	ax,s3  			;ps -- far-addr of paint-structure.
  call BEGINPAINT PASCAL,hWnd,ss,ax
	mov	hDC,ax			;hDC -- display-context, required
					;before can output to screen.

;For this simple demo, any redraw of the Window will cause output of our
;"hullo world" string....
  call	SELECTOBJECT PASCAL,ax,hOemFont
  call	TEXTOUT PASCAL,hDC,10,20, ds,OFFSET soutstring,11
	lea	ax,s3  			; -- far-addr of paint-structure.
  call	ENDPAINT PASCAL,hWnd,ss,ax
	jmp	SHORT xbreak
;........................
xmenu:
	cmp	WORD PTR lParam,0	;low-half of lParam
	jne	xbreak			;test if a menu-message.
	cmp	wParam,IDM_QUIT		;wParam.
	jne	notquit
	jmp	xquitmessage
notquit:
	cmp	wParam,IDM_ABOUT
	jne	xbreak			;no other menu items.
		;let's put up a message about this program...
call MESSAGEBOX PASCAL, hWnd, SEG szaboutstr,OFFSET szaboutstr, \
					SEG sztitlestr,OFFSET sztitlestr, MB_OK

;.........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:
	ret

WINHULLOPROC	ENDP

;.....................................................................

 END
